$(document).ready(function () {
    const hero_slider = new Swiper(".hero_slider", {
        direction: "vertical",
        slidesPerView: 2,
        spaceBetween: 20,
        speed: 900,
        centeredSlides: true,
        loop: true,
        mousewheel: {
            releaseOnEdges: true,
        },
        autoplay: {
            delay: 5000,
        },
        breakpoints: {
            0: {
                direction: "horizontal",
                slidesPerView: 1,
                spaceBetween: 10,
            },
            631: {
                direction: "horizontal",
                slidesPerView: 2,
                spaceBetween: 20,
            },
            992: {
                direction: "vertical",
                slidesPerView: 2,
                spaceBetween: 20,
            },
        },
    });
    

    const review_slider = new Swiper(".review_slider", {
        slidesPerView: 3,
        spaceBetween: 70,
        speed: 900,
        loop: true,
        autoplay: {
            delay: 5000,
        },
        navigation: {
            nextEl: ".review_next",
            prevEl: ".review_prev",
        },
        breakpoints: {
            0: {
                slidesPerView: 1,
                spaceBetween: 30,
            },
            861: {
                slidesPerView: 2,
                spaceBetween: 30,
            },
            992: {
                slidesPerView: 2,
                spaceBetween: 70,
            },
            1401: {
                slidesPerView: 3,
                spaceBetween: 70,
            },
        },
    });
    const licenses_slider = new Swiper(".licenses_slider", {
        slidesPerView: 4,
        spaceBetween: 70,
        speed: 900,
        loop: true,
        autoplay: {
            delay: 5000,
        },
        navigation: {
            nextEl: ".licenses_next",
            prevEl: ".licenses_prev",
        },
        breakpoints: {
            0: {
                slidesPerView: 1,
                spaceBetween: 30,
            },
            501: {
                slidesPerView: 2,
                spaceBetween: 30,
            },
            768: {
                slidesPerView: 3,
                spaceBetween: 30,
            },
            1201: {
                slidesPerView: 4,
                spaceBetween: 70,
            },
        },
    });
	const news_slider = new Swiper(".news_slider", {
        slidesPerView: "auto",
        speed: 900,
        loop: true,
        autoplay: {
            delay: 5000,
        },
        navigation: {
            nextEl: ".news_next",
            prevEl: ".news_prev",
        },
        breakpoints: {
            0: {
                slidesPerView: 1,
                spaceBetween: 20,
            },
            768: {
                slidesPerView: "auto",
                centeredSlides: true,
            },
            1201: {
                slidesPerView: "auto",
                centeredSlides: false,
            },
        },
    });
    const video_slider = new Swiper(".video_slider", {
        slidesPerView: 3,
        spaceBetween: 70,
        speed: 900,
        loop: true,
        autoplay: {
            delay: 5000,
        },
        navigation: {
            nextEl: ".video_next",
            prevEl: ".video_prev",
        },
        breakpoints: {
            0: {
                slidesPerView: 1,
                spaceBetween: 20,
                centeredSlides: false,
            },
            631: {
                slidesPerView: 2,
                spaceBetween: 20,
                centeredSlides: true,
            },
            861: {
                slidesPerView: 2,
                spaceBetween: 30,
            },
            992: {
                slidesPerView: 2,
                spaceBetween: 70,
            },
            1201: {
                slidesPerView: 3,
                spaceBetween: 70,
            },
        },
    });
});
