window.onload = () => {
    const loader = document.querySelector(".animation");
    const anchors = $('a').not(".recall_btn, .redirect_btn, [href='#pll_switcher'], .header_phone, .swiper-slide");
	
    setTimeout(() => {
        $(".animation").removeClass("is-active");
    }, 300);
    setTimeout(() => {
        $(
            ".page_link, .back, .nav_toggle, .logo_img"
        ).addClass("is-active");
    }, 1200);
	
	lightGallery(document.getElementById("licenses_slider"));
	
    for (let i = 0; i < anchors.length; i++) {
        const anchor = anchors[i];

        anchor.addEventListener("click", (e) => {
            e.preventDefault();
            let target = anchor.href;
			console.log(target);

            loader.classList.add("is-active");
            setTimeout(() => {
                window.location.href = target;
            }, 600);
        });
    }

    $(".nav_toggle, .shadow").on("click", function () {
        $(".header_navigation, .nav_toggle, .shadow").toggleClass("active");
    });

	 $(".lang .menu-item-has-children").on("click", function () {
        $(".lang").toggleClass("active");
    });
	
    $(".recall_close").on("click", function (e) {
        e.preventDefault();
        $(".recall").removeClass("active");
    });

    $(".recall_btn").on("click", function (e) {
        e.preventDefault();
        $(".recall").addClass("active");
    });

    $(".redirect_btn").on("click", function (e) {
        e.preventDefault();
        $(".redirect_form").addClass("active");
    });

    $(".redirect_close").on("click", function (e) {
        e.preventDefault();
        $(".redirect_form").removeClass("active");
    });

    /* convert img to svg */
    const convertImages = (query, callback) => {
        const images = document.querySelectorAll(query);

        images.forEach((image) => {
            fetch(image.src)
                .then((res) => res.text())
                .then((data) => {
                    const parser = new DOMParser();
                    const svg = parser
                        .parseFromString(data, "image/svg+xml")
                        .querySelector("svg");

                    if (image.id) svg.id = image.id;
                    if (image.className) svg.classList = image.classList;

                    image.parentNode.replaceChild(svg, image);
                })
                .then(callback)
                .catch((error) => console.error(error));
        });
    };

    convertImages("img[alt='icon']");
};
