<?php 
/* Template name: About-Page */
get_header(); 
?>
<?php $HomePageID = get_option('page_on_front'); ?>
<section class="hero">
    <div class="container">
        <div class="hero_inner">
            <div
                class="hero_info"
                style="background-image: url(<?php the_field("hero_bg") ?>)"
            >
                <div class="hero_info-block">
                    <?php the_field('hero_info'); ?>
                </div>
                <?php 
                    $hero_link = get_field('hero_link');
                    if( $hero_link ): ?>
                    <a href="<?php echo $hero_link['url'] ?>" class="btn recall_btn">
                        <?php echo $hero_link['title'] ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="hero_text">
                <div class="text">
                    <?php the_field('hero_text'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="services" style="margin: 40px; 0">
    <div class="container">
        <h3 class="blue"><?php the_field("services_title", $HomePageID) ?></h3>
        <div class="services_inner">
			<?php 
            $args = array(
			'posts_per_page' => 9999,
            'offset' => 0,
            'orderby' => 'post_date',
            'order' => 'DESC',
            'post_type' => 'services', /* your post type name */
            'post_status' => 'publish'
            );
            $query = new WP_Query($args);
            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post(); ?>
                   	<?php 
						$services_link = get_field('services_link');
						if( $services_link ): ?>              
						<a
							href="<?php echo $services_link['url'] ?>"
							class="services_item"
							style="background-image: url(<?php the_field("services_bg") ?>)"
						>
							<div class="services_block">
								<h3><?php the_field("services_title") ?></h3>
								<div class="text">
									<?php the_field("services_text"); ?>
								</div>
							</div>
						</a>
					<?php endif; ?> 
                <?php endwhile;
            endif; ?>
            <?php wp_reset_postdata() ?>
        </div>
    </div>
</section>
<section class="how about_section">
    <div class="container">
        <h3 class="blue">
            <?php the_field('how_title'); ?>
        </h3>            
		<div class="strengths">
			<?php
			if( have_rows('strengths') ):
			while( have_rows('strengths') ) : the_row(); ?>
			<div class="strengths_item">
				<div class="strengths_item-block">
					<img
						 class="strengths_img"
						 src="<?php the_sub_field('strengths_img'); ?>"
						 alt="icon"
						 />
					<div class="strengths_info">
						<h3 class="blue"><?php the_sub_field('strengths_title'); ?></h3>
						<div class="text">
							<?php the_sub_field('strengths_text'); ?>
						</div>
					</div>
				</div>
			</div>
			<?php
			endwhile;
			endif; ?>
		</div>                       
    </div>
</section>
<?php get_footer(); ?>	