<?php

//Миниатюра

if ( function_exists( 'add_theme_support' ) )

add_theme_support( 'post-thumbnails' );



//длинна текста в больших новостях

function trim_characters($count, $after = '...'){

  $excerpt = get_the_content();

  $excerpt = strip_tags($excerpt);

  $excerpt = mb_substr($excerpt, 0, $count);

  $excerpt = $excerpt . $after;

  return $excerpt;

}



//Подключение стилей

function my_theme_enqueue_style() {

    wp_enqueue_style( 'normalize', get_template_directory_uri() .'/css/normalize.css' );

    wp_enqueue_style( 'style', get_template_directory_uri() .'/style.css' );

}

add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_style' );



//Подключение скриптов

function my_theme_add_scripts() {

    wp_deregister_script( 'jquery' );

    wp_register_script( 'jquery', 'https://code.jquery.com/jquery-2.2.1.min.js');

    wp_enqueue_script( 'jquery' );

	wp_enqueue_script( 'myscript', get_template_directory_uri() . '/js/script.min.js', true);

//	wp_enqueue_script( 'myscript', get_template_directory_uri() . '/js/script.js', true);

//	wp_enqueue_script( 'less', get_template_directory_uri() . '/less/less.min.js', true );

}

add_action( 'wp_enqueue_scripts', 'my_theme_add_scripts' );



add_action('admin_menu', 'remove_admin_menu');

function remove_admin_menu() {

//	remove_menu_page('options-general.php'); // Удаляем раздел Настройки	

  	remove_menu_page('tools.php'); // Инструменты

//	remove_menu_page('users.php'); // Пользователи

//	remove_menu_page('plugins.php'); // Плагины

//	remove_menu_page('themes.php'); // Внешний вид	

	remove_menu_page('edit.php'); // Посты

	remove_menu_page('edit-comments.php'); // Комментарии

//	remove_menu_page('edit.php?post_type=acf-field-group'); // Cherry Framework

}



//меню

if ( function_exists( 'register_nav_menus' ) )

{

	register_nav_menus(

		array(

			'custom-menu'=>__('Меню сайта'),

		)

	);

}



//ACF

if( function_exists('acf_add_options_page') ) {

  acf_add_options_page(array(

    'page_title' 	=> 'Site Settings',

    'menu_title'	=> 'Site Settings',

    'menu_slug' 	=> 'option-global',

    'capability'	=> 'edit_posts',

    'redirect'		=> false

  ));

}



//customization

add_action('add_admin_bar_menus', 'reset_admin_wplogo');

function reset_admin_wplogo(  ){

	remove_action( 'admin_bar_menu', 'wp_admin_bar_wp_menu', 10 );

	add_action( 'admin_bar_menu', 'my_admin_bar_wp_menu', 10 );

}

function my_admin_bar_wp_menu( $wp_admin_bar ) {

	$wp_admin_bar->add_menu( array(

		'id'    => 'wp-logo',

		'title' => '<img src="https://danilsmg.ru/wp-content/themes/el1t_new/img/el1t_wp_admin_logo.png" alt="danilsmg.ru" >',

		'href'  => home_url('/'),

		'meta'  => array(

			'title' => 'danilsmg.ru - создание продающих сайтов',

		),

	) );

}

//customization

function remove_footer_admin () {

    echo "Спасибо за совместное творчество с <a href='https://danilsmg.ru' target='_blank'>«DanilSMG»</a>";

} 

add_filter('admin_footer_text', 'remove_footer_admin');

//customization

function my_login_logo(){

echo '

    <style engine="text/css">

        #login h1 a { 

            background: url(https://danilsmg.ru/wp-content/themes/el1t_new/img/logo_danilsmg.svg) no-repeat 50% 50% !important;

            width: 100%;

            height: 30px;

        }

    </style>';

}

add_action('login_head', 'my_login_logo');

add_filter( 'login_headerurl', create_function('', 'return get_home_url();') );

add_filter( 'login_headertitle', create_function('', 'return false;') );



add_action('admin_head', 'my_custom_styles');

function my_custom_styles() {

    echo '

    <style>

        #toplevel_page_edit-post_type-search-filter-widget,

        #menu-posts-rl_gallery,

        #toplevel_page_responsive-lightbox-settings{

            display: none !important;

        }

    </style>';

}



//SVG

add_filter( 'upload_mimes', 'svg_upload_allow' );

function svg_upload_allow( $mimes ) {

	$mimes['svg']  = 'image/svg+xml';

	return $mimes;

}



add_filter( 'wp_check_filetype_and_ext', 'fix_svg_mime_type', 10, 5 );

function fix_svg_mime_type( $data, $file, $filename, $mimes, $real_mime = '' ){

	if( version_compare( $GLOBALS['wp_version'], '5.1.0', '>=' ) )

		$dosvg = in_array( $real_mime, [ 'image/svg', 'image/svg+xml' ] );

	else

		$dosvg = ( '.svg' === strtolower( substr($filename, -4) ) );

	if( $dosvg ){

		if( current_user_can('manage_options') ){

			$data['ext']  = 'svg';

			$data['type'] = 'image/svg+xml';

		}

		else {

			$data['ext'] = $type_and_ext['type'] = false;

		}

	}

	return $data;

}



add_filter( 'wp_prepare_attachment_for_js', 'show_svg_in_media_library' );

function show_svg_in_media_library( $response ) {

	if ( $response['mime'] === 'image/svg+xml' ) {

		$response['image'] = [

			'src' => $response['url'],

		];

	}

	return $response;

}

//SVG



//мультиязык

pll_register_string('phone-descr', 'Call me back');

pll_register_string('contacts-title', 'Contacts');

pll_register_string('modal-title', 'Contact us');

pll_register_string('input-name', 'Name');

pll_register_string('input-surname', 'Surname');

pll_register_string('input-phone', 'Phone number');

pll_register_string('input-companyname', 'Company name');

pll_register_string('input-msg', 'Message');

pll_register_string('input-info', 'I agree with processing of my personal data');

pll_register_string('modal-btn', 'Send');

pll_register_string('modal-thanks-title', 'The request was sent successfully');

pll_register_string('modal-thanks-descr', 'We will contact you soon, thank you!');

//мультиязык