<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title><?php bloginfo('description'); ?></title>

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap"
        rel="stylesheet"
    />
    <link
        rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css"
    />
    <link
        rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/lightgallery@2.3.0-beta.4/css/lightgallery.css"
    />
    <?php wp_head(); ?>

</head>
<body style="background-image: url(<?php bloginfo('template_url'); ?>/assets/img/bg.svg)">
    <div class="animation is-active">
        <span></span>
        <span></span>
        <span></span>
    </div>
    <div class="shadow"></div>
	<?php $HomePageID = get_option('page_on_front'); ?>
	<?php $HomePageURL = getTplPageURL('index'); echo $HomePageURL; ?>
    <header class="header">
        <div class="container">
            <div class="header_inner">
                <a class="logo" href="<?php echo get_home_url(); ?>">
                    <img src="<?php the_field('logo', $HomePageID) ?>" alt="logo">
                </a>
                <div class="header_navigation">
                    <nav class="nav">
                        <?php
                            wp_nav_menu(array('theme_location' => 'primary'));
                        ?>
                    </nav>
					<a href="tel:<?php the_field('header_phone', $HomePageID); ?>" class="header_phone">
						<img src="<?php bloginfo('template_url'); ?>/assets/img/phone.svg" alt="phone" />
						<?php the_field('header_phone'); ?>
						<span><?php the_field('header_phone_text', $HomePageID) ?></span>
					</a>
                    <div class="lang">
						<a class="redirect_btn header_country"><?php the_field('site_country', $HomePageID); ?></a>
                        <?php wp_nav_menu( array( 'menu'  => 'language'  ) ); ?>
                    </div>
                </div>
                <button class="nav_toggle"></button>
            </div>
        </div>
    </header>
    <main>
		<?php
			if ( function_exists('yoast_breadcrumb') && !is_front_page() && !is_404() ) { ?>
				<section class="breadcrumbs">
					<div class="container">
						<?php
							  yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );	
						?>
					</div>
				</section>
		<?php	}
		?>