<?php 
/* Template name: Contact-Page */
get_header(); 
?>
<section class="hero">
    <div class="container">
        <div class="hero_inner">
            <div
                class="hero_info"
                style="background-image: url(<?php the_field('hero_bg'); ?>)"
            >
                <div class="hero_info-block">
                    <?php the_field('hero_info'); ?>
                </div>
                <?php 
                    $hero_link = get_field('hero_link');
                    if( $hero_link ): ?>
                    <a href="<?php echo $hero_link['url'] ?>" class="btn">
                        <?php echo $hero_link['title'] ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="hero_text">
                <div class="text">
                    <?php the_field('hero_text'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="contacts">
    <div class="container">
        <div
            class="contacts_inner"
            style="background-image: url(<?php the_field('map'); ?>)"
        >
            <div class="contacts_inner-block">
                <h3 class="orange"><?php the_field('contact_title_1'); ?></h3>
                <div class="contacts_item">
                    <img src="<?php bloginfo('template_url'); ?>/assets/img/geo.svg" alt="geo" />
                    <div class="text">
                        <?php the_field('contact_text_1'); ?>
                    </div>
                </div>
                <div class="contacts_item">
                    <img src="<?php bloginfo('template_url'); ?>/assets/img/geo.svg" alt="geo" />
                    <div class="text">
                        <?php the_field('contact_text_2'); ?>
                    </div>
                </div>
                <h3 class="orange"><?php the_field('contact_title_2'); ?></h3>
                <div class="contacts_item">
                    <img src="<?php bloginfo('template_url'); ?>/assets/img/phone-3.svg" alt="phone" />
                    <a href="tel:<?php the_field('contact_phone'); ?>"><?php the_field('contact_phone'); ?></a>
                </div>
                <div class="contacts_item">
                    <img src="<?php bloginfo('template_url'); ?>/assets/img/whatapp-2.svg" alt="whatsapp" />
                    <a href="tel:<?php the_field('contact_phone_2'); ?>"><?php the_field('contact_phone_2'); ?></a>
                </div>
                <h3 class="orange"><?php the_field('contact_title_3'); ?></h3>
                <div class="contacts_item">
                    <img src="<?php bloginfo('template_url'); ?>/assets/img/email-2.svg" alt="email" />
                    <a href="mailto:<?php the_field('contact_mail'); ?>">
                        <?php the_field('contact_mail'); ?>
                    </a>
                </div>
                <div class="contacts_item">
                    <img src="<?php bloginfo('template_url'); ?>/assets/img/site.svg" alt="website" />
                    <a href="<?php the_field('contact_site'); ?>"> <?php the_field('contact_site'); ?> </a>
                </div>
            </div>
			<div class="form" style="background-image: url(<?php bloginfo('template_url'); ?>/assets/img/form.png)">
				<?php the_field('contact_form'); ?>
			</div>
        </div>
    </div>
</section>
<?php get_footer(); ?>	