<?php get_header(); 
?> 
<?php $term = get_queried_object(); ?>
<section class="hero">
    <div class="container">
        <div class="hero_inner">
			<?php $BlogPageID = getTplPageID('blog'); ?>
            <div
                class="hero_info"
                style="background-image: url(<?php the_field('hero_bg', $BlogPageID); ?>)"
            >
                <div class="hero_info-block">
                    <?php the_field('hero_info', $BlogPageID); ?>	
                </div>
                <?php 
                    $hero_link = get_field('hero_link', $BlogPageID);
                    if( $hero_link ): ?>
                    <a href="<?php echo $hero_link['url'] ?>" class="btn">
                        <?php echo $hero_link['title'] ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="hero_text">
                <div class="text">
                    <?php the_field('hero_text', $BlogPageID); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="blog">
    <div class="container">
        <div class="blog_inner">
            <div class="blog_info">
				<h4><?php the_field('search_title', $BlogPageID); ?></h4>
				<?php echo do_shortcode( '[ivory-search id="5073" title="AJAX Search Form"]' ); ?>
                <h4><?php the_field('category_title', $BlogPageID); ?></h4>
                <div class="category">
					<a href="<?php echo getTplPageURL('blog'); ?>" class="category_item" style="background-image: url(<?php bloginfo('template_url'); ?>/assets/img/category-5.png)">
						<h3>
							All
						</h3>
					</a>
                    <?php
						$categoryActive = false;
						$categoriesBg = array(
							"/assets/img/category-1.png",
							"/assets/img/category-2.png",
							"/assets/img/category-3.png",
							"/assets/img/category-4.png",
						);
						$categoriesIdx = 0;
                        $categories = get_categories();
                        foreach($categories as $category) { 
							 if($term->name === $category->name){$categoryActive = true;}else{$categoryActive = false;}?>                             
							<a href="<?php echo get_category_link($category->term_id); ?>" class="category_item <?php echo $categoryActive ? 'active' : null; ?>" style="background-image: url(<?php bloginfo('template_url'); ?>/<?php echo $categoriesBg[$categoriesIdx]; ?>)">
								<h3>
									<?php echo $category->name; ?>
								</h3>
							</a>
						<?php $categoriesIdx++;
                        }
                    ?>
                </div>
                <h4><?php the_field('blog_title'); ?></h4>
                <div class="posts">
                    <?php echo do_shortcode('[ajax_load_more container_type="div" post_type="post" posts_per_page="7" category="' .$term->slug. '" scroll="true"]'); ?>  
                </div>
            </div>
            <div class="blog_aside">
                <?php 
					$args = array(
						'posts_per_page' => 9999,
						'offset' => 0,
						'orderby' => 'post_date',
						'order' => 'DESC',
						'post_type' => 'services', /* your post type name */
						'post_status' => 'publish'
					);
					$query = new WP_Query($args);
					if ($query->have_posts()) :
					while ($query->have_posts()) : $query->the_post(); ?>
					<?php 
					$services_link = get_field('services_link');
					if( $services_link ): ?>              
					<a
					   href="<?php echo $services_link['url'] ?>"
					   class="services_item"
					   style="background-image: url(<?php the_field("services_bg") ?>)"
					   >
						<h3><?php the_field("services_title") ?></h3>
					</a>
					<?php endif; ?> 
					<?php endwhile;
					endif; ?>
				<?php wp_reset_postdata() ?>
                <div class="blog_subscribe">
                    <h3 class="orange"><?php the_field('subscribe_text', $BlogPageID); ?></h3>
                    <div class="form">
						<?php echo do_shortcode('[mailpoet_form id="1"]'); ?>   
					</div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>	