<?php 
/* Template name: CIF-Page */
get_header(); 
?>
<span class="sticky">
	<?php $HomePageID = get_option('page_on_front'); ?>
    <span> <?php the_field('site_country', $HomePageID); ?> </span>
</span>
<section class="hero">
    <div class="container">
        <div class="hero_inner">
            <div
                class="hero_info"
                style="background-image: url(<?php the_field('hero_bg'); ?>)"
            >
                <div class="hero_info-block">
                    <?php the_field('hero_info'); ?>
                </div>
                <?php 
                    $hero_link = get_field('hero_link');
                    if( $hero_link ): ?>
                    <a href="<?php echo $hero_link['url'] ?>" class="btn recall_btn">
                        <?php echo $hero_link['title'] ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="hero_text">
                <div class="text">
                    <?php the_field('hero_text'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="about cif">
    <div class="container">
        <?php
        if( have_rows('about_inner') ):
            while( have_rows('about_inner') ) : the_row(); ?>
                <div class="about_inner">
                    <div class="about_info">
                        <div class="text">
                            <?php the_sub_field('about_text'); ?>
                        </div>
                    </div>
                    <div class="about_img">
                        <?php 
                            $about_link = get_sub_field('about_link');
                            if( $about_link ): ?>
                            <a href="<?php echo $about_link['url'] ?>" class="btn recall_btn">
                                <?php echo $about_link['title'] ?>
                            </a>
                        <?php endif; ?>
                        <img src="<?php the_sub_field('about_img'); ?>" alt="about" />
                    </div>
                </div>
            <?php
            endwhile;
        endif; ?>
    </div>
</section>
<?php get_footer(); ?>	