<?php get_header(); ?>
<section class="hero"> 
    <div class="container">
        <div class="hero_inner">
            <div
                class="hero_info"
                style="background-image: url(<?php the_field("hero_bg") ?>)"
            >
                <div class="hero_info-block">
                    <?php the_field("hero_info") ?>
                </div>
                <?php 
                    $hero_link = get_field('hero_link');
                    if( $hero_link ): ?>
                    <a href="<?php echo $hero_link['url'] ?>" class="btn recall_btn">
                        <?php echo $hero_link['title'] ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="swiper hero_slider">
                <div class="swiper-wrapper">
					<?php 
					$args = array(
					'posts_per_page' => 9999,
					'offset' => 0,
					'orderby' => 'post_date',
					'order' => 'DESC',
					'post_type' => 'services', /* your post type name */
					'post_status' => 'publish'
					);
					$query = new WP_Query($args);
					if ($query->have_posts()) :
						while ($query->have_posts()) : $query->the_post(); ?>
							<?php 
								$services_link = get_field('services_link');
								if( $services_link ): ?>              
								<a
									href="<?php echo $services_link['url'] ?>"
									class="swiper-slide services_item"
									style="background-image: url(<?php the_field("services_bg") ?>)"
								>
									<h3><?php the_field("services_title") ?></h3>
								</a>
							<?php endif; ?> 
						<?php endwhile;
					endif; ?>
					<?php wp_reset_postdata() ?>					
                </div>
            </div>
        </div>
    </div>
</section>
<section class="about">
    <div class="container">
        <div class="about_inner">
            <div class="about_info">
                <h4><?php the_field("about_title") ?></h4>
                <h3 class="blue"><?php the_field("about_undertitle") ?></h3>
                <div class="text">
                    <?php the_field("about_text") ?>
					
                </div>
				 <?php 
				 $about_link = get_field('about_link');
						if( $about_link ): ?>
					<a href="<?php echo $about_link['url'] ?>" class="more">
						<?php echo $about_link['title'] ?>
					</a>
				 <?php endif; ?>
            </div>
            <div class="about_img">
                <img src="<?php the_field("about_img") ?>" alt="about" />
            </div>
        </div>
    </div>
</section>
<section class="licenses">
    <div class="container">
        <h4><?php the_field("licenses_title") ?></h4>
        <div class="slider_outer">
            <div class="swiper licenses_slider">
                <div class="swiper-wrapper" id="licenses_slider">
                    <?php
                    if( have_rows('licenses_slider') ):
                        while( have_rows('licenses_slider') ) : the_row(); ?>
                        <a
                            href="<?php the_sub_field("license_img") ?>"
                            class="swiper-slide"
                        >
                            <img src="<?php the_sub_field("license_thumb") ?>" />
                        </a>
                        <?php
                        endwhile;
                    endif; ?>
                </div>
                <div class="swiper-button-next licenses_next"></div>
                <div class="swiper-button-prev licenses_prev"></div>
            </div>
        </div>
    </div>
</section>
<section class="services">
    <div class="container">
        <h4><?php the_field("services_title") ?></h4>
        <div class="services_inner">
			<?php 
            $args = array(
			'posts_per_page' => 9999,
            'offset' => 0,
            'orderby' => 'post_date',
            'order' => 'DESC',
            'post_type' => 'services', /* your post type name */
            'post_status' => 'publish'
            );
            $query = new WP_Query($args);
            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post(); ?>
                   	<?php 
						$services_link = get_field('services_link');
						if( $services_link ): ?>              
						<a
							href="<?php echo $services_link['url'] ?>"
							class="services_item"
							style="background-image: url(<?php the_field("services_bg") ?>)"
						>
							<div class="services_block">
								<h3><?php the_field("services_title") ?></h3>
								<div class="text">
									<?php the_field("services_text"); ?>
								</div>
							</div>
						</a>
					<?php endif; ?> 
                <?php endwhile;
            endif; ?>
            <?php wp_reset_postdata() ?>
        </div>
    </div>
</section>
<section class="news">
    <div class="container">
        <h4><?php the_field("news_title") ?></h4>
        <div class="slider_outer">
            <div class="swiper news_slider">
                <div class="swiper-wrapper">
					<?php
						$count_items = 6;//кол-во выводимых элементов
						$recent = new WP_Query( "posts_per_page=$count_items" );//Сам запрос
						while ( $recent->have_posts() ) {
							$recent->the_post();
							?>
							<div class="swiper-slide posts_item">
								<div class="news_img">
									<img src="<?php echo get_the_post_thumbnail() ?>" alt="news" />
								</div>
								<div class="news_info">
									<div class="news_top">
										<span>
											<strong><?php the_category(); ?></strong>
										</span>
										<span><?php echo get_the_date(); ?></span>
									</div>
									<h4 class="blue">
										<?php the_title(); ?>
									</h4>
									<div class="text">
										<?php the_field("single_text") ?>
									</div>
									<a href="<?php the_permalink() ?>" class="more">Read more</a>
								</div>
							</div>
							<?php
						}
						wp_reset_postdata();
					?>
					
                </div>
                <div class="swiper-button-next news_next"></div>
                <div class="swiper-button-prev news_prev"></div>
            </div>
        </div>
    </div>
</section>
<section class="review">
    <div class="container">
        <h4><?php the_field("review_title") ?></h4>
        <div class="slider_outer">
            <div class="swiper review_slider">
                <div class="swiper-wrapper">
                    <?php
                        if( have_rows('review_slider') ):
                        while( have_rows('review_slider') ) : the_row(); ?>
                        <div class="swiper-slide">
                            <div class="review_info">
                                <div class="text">
                                    <?php the_sub_field("review_text") ?>
                                </div>
                            </div>
                            <div class="review_bottom">
                                <div class="quotes">
                                    <img
                                        src="<?php bloginfo('template_url'); ?>/assets/img/quotes.svg"
                                        alt="quotes"
                                    />
                                </div>
                                <div class="review_bottom-info">
                                    <h4 class="blue"><?php the_sub_field("review_name") ?></h4>
                                    <div class="text">
                                        <?php the_sub_field("review_info") ?>
                                    </div>
                                </div>
                                <?php 
                                    $review_link = get_field('review_link');
                                    if( $review_link ): ?>
                                    <a href="<?php echo $review_link['url'] ?>" class="review_social">
                                        <img
                                            src="<?php the_field("review_link-1") ?>"
                                            alt="Facebook"
                                        />
                                    </a>
                                <?php endif; ?>
                            
                            </div>
                        </div>
                        <?php
                        endwhile;
                    endif; ?>
                </div>
                <div class="swiper-button-next review_next"></div>
                <div class="swiper-button-prev review_prev"></div>
            </div>
        </div>
    </div>
</section>
<?php get_footer(); ?>	