<?php
add_theme_support('menus');
add_action( 'wp_enqueue_scripts', 'aif_style' );
add_action( 'wp_enqueue_scripts', 'aif_scripts' );

add_filter('wpcf7_autop_or_not', '__return_false');

function aif_style() {
    wp_enqueue_style( 'normalize-style', get_template_directory_uri() . '/assets/css/normalize.css' );
    wp_enqueue_style( 'lightgallery-style', get_template_directory_uri() . '/assets/css/lightgallery.css' );

    wp_enqueue_style( 'main-style', get_stylesheet_uri() );

}

function aif_scripts() {
  	wp_deregister_script( 'jquery' );
    wp_register_script( 'jquery', get_template_directory_uri() . '/assets/js/jquery.min.js' );
    wp_enqueue_script( 'jquery' );

    wp_enqueue_script( 'lightgallery-script', get_template_directory_uri() . '/assets/js/lightgallery.min.js', array('jquery'), null, true );
    wp_enqueue_script( 'slider-script', get_template_directory_uri() . '/assets/js/slider.js', array('jquery'), null, true );
    wp_enqueue_script( 'main-script', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), null, true );
}


function getTplPageURL( $template_name ){
	$page = get_pages(array(
		'meta_key' => '_wp_page_template',
		'meta_value' => $template_name . '.php'
	));
	if(!empty($page)){
		return get_permalink( $page[0]->ID );
	}
}

function getTplPageID ( $template_name ){
	$pages = get_pages(array(
		'meta_key' => '_wp_page_template',
		'meta_value' => $template_name . '.php'
	));
	foreach($pages as $page){
		return $page->ID ;
	}
}

add_action( 'after_setup_theme', 'theme_register_nav_menu' );

function theme_register_nav_menu() {
	register_nav_menu( 'primary', 'Primary Menu' );
}

if( function_exists('acf_add_options_page') ) {
	acf_add_options_page();
	acf_add_options_sub_page("Modal");
}

add_theme_support( 'post-thumbnails' ); 