<?php /*Template Name: Главная*/ ?>
<?php get_header(); ?>
    <div class="intro">
        <div class="container">
            <div class="title"><?php the_field('заголовок_первого_блока'); ?></div>
            <div class="container-min">
                <div class="text">
                    <div class="descr-big"><p><?php the_field('подзаголовок_первого_блока'); ?></p></div>
                    <div class="btn-block">
                        <a class="btn" href="javascript:PopUpShow1()"><?php the_field('название_кнопки'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
   
    <?php if( have_rows('слайдер') ): ?>
    <div class="slider-home">
        <div class="container">
            <div class="descr-big descr-big--title"><?php the_field('заголовок_слайдера'); ?></div>
            <div class="slider_block js-tabs" data-tabs-container>
                <div class="container">
                    <div class="slider-text">
                        <div class="slider-text--cont">
                            <?php $i=0; ?>
                            <?php while( have_rows('слайдер') ): the_row(); $i++; ?>
                            <div class="slider--inner" id="tab-<?php echo $i; ?>">
                                <div class="miniature">
                                    <?php 
                                    $image = get_sub_field('изображение');
                                    if( !empty($image) ): ?>
                                        <img src="<?php echo $image['sizes']['medium_large']; ?>" alt="<?php echo $image['alt']; ?>" />
                                    <?php endif; ?>
                                </div>
                                <div class="descr-big"><p><?php the_sub_field('текст'); ?></p></div>
                            </div>
                            <?php endwhile; ?>
                            
                            <div class="dots-slide">
                                <?php $i2=0; ?>
                                <?php while( have_rows('слайдер') ): the_row(); $i2++; ?>
                                <a class="dots--inner" href="#tab-<?php echo $i2; ?>"></a>
                                <?php endwhile; ?>
                            </div>
                            <div class="btn-block">
                                <a class="btn" href="javascript:PopUpShow1()"><?php the_field('название_кнопки'); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    
    <div class="about" id="about">
        <div class="container">
            <div class="content-title"><?php the_field('about_block_header'); ?></div>
            <div class="container-min">
                <div class="flex_block">
                    <div class="about--inner">
                        <div class="entrytext"><?php the_field('text_on_the_left_about'); ?></div>
                        <div class="miniature">
                            <?php 
                            $image = get_field('image_on_the_left_about');
                            if( !empty($image) ): ?>
                                <img src="<?php echo $image['sizes']['medium_large']; ?>" alt="<?php echo $image['alt']; ?>" />
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="about--inner">
                        <div class="miniature">
                            <?php 
                            $image = get_field('image_on_the_right_about');
                            if( !empty($image) ): ?>
                                <img src="<?php echo $image['sizes']['medium_large']; ?>" alt="<?php echo $image['alt']; ?>" />
                            <?php endif; ?>
                        </div>
                        <div class="entrytext"><?php the_field('text_on_the_right_about'); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php if( have_rows('services') ): ?>
    <div class="services-company" id="services">
        <div class="container">
            <div class="content-title"><?php the_field('services_block_header'); ?></div>
            <div class="descr-big"><?php the_field('subtitle_of_the_services_block'); ?></div>
            <div class="flex_block">
                <?php while( have_rows('services') ): the_row(); ?>
                <div class="services--inner">
                    <div class="icon">
                        <div class="icon-cont">
                            <span style="background-image: url('<?php the_sub_field('icon'); ?>');"></span>
                        </div>
                    </div>
                    <div class="title"><?php the_sub_field('title'); ?></div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if( have_rows('why_us') ): ?>
    <div class="features" id="whyus">
        <div class="container">
            <div class="content-title"><?php the_field('the_why_us_block_header'); ?></div>
            <div class="descr-big descr-big--title"><?php the_field('subtitle_of_the_why_us_block'); ?></div>
        </div>
        <div class="features_block">
            <div class="container">
                <div class="flex_block">
                    <?php while( have_rows('why_us') ): the_row(); ?>
                    <div class="features--inner">
                        <div class="ft-inner--cont">
                            <?php if( get_sub_field('num') ): ?>
                            <div class="num"><span data-count="<?php the_sub_field('num'); ?>">0</span><?php the_sub_field('the_sign_after_the_number'); ?></div>
                            <?php endif; ?>
                            <div class="descr-big"><p><?php the_sub_field('text'); ?></p></div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                    <div class="btn-block">
                        <a class="btn" href="javascript:PopUpShow1()"><?php the_field('название_кнопки'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <?php
    $images = get_field('clients_logos');
    if( $images ): ?>
    <div class="clients" id="clients">
        <div class="container">
            <div class="content-title"><?php the_field('title_of_the_clients_block'); ?></div>
            <div class="descr-big descr-big--title"><?php the_field('subtitle_of_the_clients_block'); ?></div>
            <div class="flex_block">
                <?php foreach( $images as $image ): ?>
                <div class="clients--inner">
                    <img src="<?php echo esc_url($image['sizes']['medium']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php get_footer() ?>