<!DOCTYPE HTML>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width">
        <title><?php echo wp_get_document_title(); ?></title>
        
<!--        <link rel="stylesheet/less" href="<?php bloginfo( 'template_url' ); ?>/less/style.less">-->
        <?php wp_head(); ?>
    </head>
    
    <body <?php body_class( $class ); ?>>

        <header class="my-head" id="top">
            <div class="container clearfix">
                <a class="logo" href="/"></a>
                <div class="btn-block">
                    <a class="phone" href="tel:<?php the_field('phone', 'option'); ?>">
                        <span class="phone-big"><?php the_field('phone', 'option'); ?></span>
                        <span class="phone-title"><?php echo pll_e('Call me back'); ?></span>
                    </a>
                    <div class="language">
                        <?php pll_the_languages(); ?>
                    </div>
                    <div class="socials">
                        <a class="soc--inner whatsapp" href="https://api.whatsapp.com/send?phone=<?php the_field('whatsapp', 'option'); ?>" target="_blank"></a>
                        <a class="soc--inner facebook" href="<?php the_field('facebook', 'option'); ?>" target="_blank"></a>
                    </div>
                </div>
                <div class="menu-smg">
                    <a class="btn-menu">
                        <div class="icon">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </a>
                    <div class="menu-animate-mobile">
                        <?php wp_nav_menu([ 'theme_location'  => 'custom-menu' ]); ?>
                    </div>
                </div>
            </div>
        </header>
