<?php
/* ------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------

						ENREGISTREMENT DU CUSTOM POST TYPE - services

---------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------ */

/* Ajout du catalogue services */
add_action( 'init', 'codex_services_init' );
function codex_services_init() {
	$labels = array(
		'name'               => _x( 'services', 'post type general name', 'theme-aif' ),
		'singular_name'      => _x( 'services', 'post type singular name', 'theme-aif' ),
		'menu_name'          => _x( 'Services', 'admin menu', 'theme-aif' ),
		'name_admin_bar'     => _x( 'services', 'add new on admin bar', 'theme-aif' ),
		'add_new'            => _x( 'Add services', 'services', 'theme-aif' ),
		'add_new_item'       => __( 'Add new services', 'theme-aif' ),
		'new_item'           => __( 'new services', 'theme-aif' ),
		'edit_item'          => __( 'Change l\'services', 'theme-aif' ),
		'view_item'          => __( 'View l\'services', 'theme-aif' ),
		'all_items'          => __( 'All services', 'theme-aif' ),
		'search_items'       => __( 'Find services', 'theme-aif' ),
		'parent_item_colon'  => __( 'Parrent services :', 'theme-aif' ),
		'not_found'          => __( 'No services.', 'theme-aif' ),
		'not_found_in_trash' => __( 'No services in banch.', 'theme-aif' )
	);
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'menu_icon'          => 'dashicons-clipboard',
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'services' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'supports'           => array( 'title', 'editor', 'author', 'revisions', 'thumbnail', 'excerpt', 'comments', 'page-attributes' )
    );
    register_post_type( 'services', $args );
}
/* Ajout des messages pour les services */
add_filter( 'post_updated_messages', 'codex_services_updated_messages' );
function codex_services_updated_messages( $messages ) {
	$post             = get_post();
	$post_type        = get_post_type( $post );
	$post_type_object = get_post_type_object( $post_type );
	$messages['services'] = array(
		0	=> '',
		1	=> __( 'service update.', 'theme-aif' ),
		2	=> __( 'service update.', 'theme-aif' ),
		3	=> __( 'services removed.', 'theme-aif' ),
		4	=> __( 'service update.', 'theme-aif' ),
		5	=> isset( $_GET['revision'] ) ? sprintf( __( 'services mise à jour avec la révision du %s', 'theme-aif' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6	=> __( 'published services.', 'theme-aif' ),
		7	=> __( 'registered services.', 'theme-aif' ),
		8	=> __( 'submissive services.', 'theme-aif' ),
		9	=> sprintf(
			__( 'Publication of l\'services for : <strong>%1$s</strong>.', 'theme-aif' ),
			date_i18n( __( 'j M Y @ G:i', 'theme-aif' ), strtotime( $post->post_date ) )
			),
		10	=> __( 'Draft l\'Services Updated.', 'theme-aif' )
	);
	if ( $post_type_object->publicly_queryable ) {
		$permalink = get_permalink( $post->ID );
		if($post_type=='services'){
			$view_link = sprintf( ' <a href="%s">%s</a>', esc_url( $permalink ), __( 'View l\'services', 'theme-aif' ) );
			$messages[ $post_type ][1] .= $view_link;
			$messages[ $post_type ][6] .= $view_link;
			$messages[ $post_type ][9] .= $view_link;

			$preview_permalink = add_query_arg( 'preview', 'true', $permalink );
			$preview_link = sprintf( ' <a target="_blank" href="%s">%s</a>', esc_url( $preview_permalink ), __( 'Preview l\'services', 'theme-aif' ) );
			$messages[ $post_type ][8]  .= $preview_link;
			$messages[ $post_type ][10] .= $preview_link;
		}
	}
	return $messages;
}
/* Ajout des catégories de services */
add_action( 'init', 'create_services_taxonomies', 0 );
function create_services_taxonomies() {
	$labels = array(
		'name'              => _x( 'Categories-services', 'taxonomy general name' ),
		'singular_name'     => _x( 'Categories-services', 'taxonomy singular name' ),
		'search_items'      => __( 'Rechercher les catégories' ),
		'all_items'         => __( 'Search Categories' ),
		'parent_item'       => __( 'Parent category' ),
		'parent_item_colon' => __( 'Parent category :' ),
		'edit_item'         => __( 'Modifier la catégorie' ),
		'update_item'       => __( 'Change category' ),
		'add_new_item'      => __( 'Add a category' ),
		'new_item_name'     => __( 'Category name' ),
		'menu_name'         => __( 'Categories' ),
	);
	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'category-services' ),
	);
	register_taxonomy('category-services',array('services'),$args);
}
/* Ajout de la colonne "Marque" dans l'admin pour les services */
add_filter( 'manage_edit-services_columns', 'my_edit_services_columns' ) ;
function my_edit_services_columns( $columns ) {
	$columns = array(
		'cb' => '<input type="checkbox" />',
		'title' => __( 'Nom' ),
		'category' => __( 'Catégorie' ),
		'date' => __( 'Date' )
	);
	return $columns;
}
add_action( 'manage_services_posts_custom_column', 'my_manage_services_columns', 10, 2 );
function my_manage_services_columns( $column, $post_id ) {
	global $post;
	switch( $column ) {
		case 'category' :
            $terms = get_the_terms( $post_id, 'category' );
            if(!empty($terms)){
                $out = array();
                foreach($terms as $term){
                    $out[] = sprintf( '<a href="%s">%s</a>',
                        esc_url( add_query_arg( array( 'post_type' => $post->post_type, 'category' => $term->slug ), 'edit.php' ) ),
                        esc_html( sanitize_term_field( 'name', $term->name, $term->term_id, 'category', 'display' ) )
                        );
                }
                echo join( ', ', $out );
            }else {
                _e( 'Non renseigné' );
            }
		break;
		default :
		break;
	}
}
?>